# Amass Enum

Amass enum is where most of Amass' powerful capabilities reside. It allows you to perform DNS enumeration and mapping of the target to determine the attack surface exposed by organizations. The enumeration findings are stored in a graph database, which will be located in Amass' default output folder or the specified output directory using the "-dir" flag. This is also the case with other Amass subcommands.

## Run Amass under Passive or Active Configuration

Amass enum can be executed under the context of a passive or an active configuration mode. The passive mode is much quicker, but Amass will not validate DNS information, for example by resolving the subdomains. You can run it passively using the "-passive" flag and you will not be able to enable many techniques or configurations, such as DNS resolution and validation. There are several reasons for choosing passive mode over the active mode at times, for example:

- You need to know all possible subdomains that have been used and may be reused in the future, perhaps because you need to constantly monitor the target's attack surface for changes or because you are working on a phishing engagement and looking for subdomains.
- Your perimeter's security testing process validates DNS information at a later stage and need Amass results quickly.
- Due to a security engagement's constraints or requirements, you can only perform passive information gathering.

In the below example, we are passively searching for subdomains on owasp.org while asking Amass to display the data sources where it found each subdomain:

```bash
$ amass enum -passive -d owasp.org -src
[...]
[ThreatCrowd]     update-wiki.owasp.org
[...]
[BufferOver]      my.owasp.org
[Crtsh]           www.lists.owasp.org
[Crtsh]           www.ocms.owasp.org
[...]
Querying VirusTotal for owasp.org subdomains
Querying Yahoo for owasp.org subdomains
[...]
```

It is worth stating at this point that although Amass intel will help gather IP ranges, ASNs, and parent domains owned by an organization, Amass enum will identify all subdomains. This subdomain enumeration is completed in under 2 minutes on my test machine. Here's a slightly modified screenshot showing the results of this enumeration:

Using Amass in active configuration mode means that you will have more accurate results and more assets may be discovered as you can enable all DNS enumeration techniques. It should be noted that by "active configuration mode" we are not strictly referring to the "-active" flag which enables zone transfers and port scanning of SSL/TLS services and grabbing their certificates to extract any subdomains from certificate fields (e.g. Common Name).

The below command (a detailed explanation of which follows below) can be considered active overall as it performs subdomain brute-forcing in multiple ways (wordlist, masks, etc.) along with the "-active" flag being enabled. All findings will be validated by Amass using the default or the specified resolvers:

```bash
# amass enum -active -d owasp.org -brute -w /root/dns_lists/deepmagic.com-top50kprefixes.txt -src -ip -dir amass4owasp -config /root/amass/config.ini -o amass_results_owasp.txt
```

The command we have used above specifies that the Amass graph database along with log files will be stored at "./amass4owasp". We have also asked Amass to display the data sources for each identified subdomain and the IP address(es) it resolves to with the "-src" and "-ip" flags respectively. We have provided Amass with the deepmagic DNS wordlist with the "-w" argument, and also specified the location of the config.ini file with "-config" and the output with "-o".

While the command above is hopefully straightforward, we would like to provide some further notes:

- In this instance, Amass would check within the config.ini file for DNS resolvers or use the default ones embedded within the Amass code. You can also specify your own DNS resolvers either with the use of the "-r" and "-rf" flags or within the config.ini file. Using the "-r" flag you can specify the IP addresses of DNS resolvers at the command, while with the "-rf" you can specify a file containing these.
- We could have specified all these configurations in a config.ini file and provide this to Amass with "-config". It's worth stating at this point that command-line arguments will take priority over what's specified in the config.ini file. So, if you are disabling brute-force in the config.ini file, but supply the "-brute" argument on the command line, then brute-force techniques will be used.
- The command above, unless explicitly disabled with the use of the "-norecursive", will perform recursive DNS enumeration on subdomains identified by default.

At this point, you should also keep in mind that if you are performing multiple Amass operations within short periods of time from the same IP, the IP may be permanently blocked from some sources that Amass is scraping such as the Google/Yahoo search engines.

If you require multiple instances of Amass to be executed at the same time, you may be able to achieve this on the same server; however, bear in mind that Amass is powerful and will consume a lot of resources. Additionally, you will need to use the "dir" flag to specify separate output directories, and hence graph databases, when running multiple instances of Amass.

To conclude this section in a more interesting way, let's assume that for some reason the OWASP organisation tends to create subdomains with "zzz" prefixes, such as zzz-dev.owasp.org. You can leverage Amass' hashcat-style wordlist mask feature to brute-force all the combinations of "zzz-[a-z][a-z][a-z].owasp.org" using the following command:

```bash
# amass enum -d owasp.org -norecursive -noalts -wm "zzz-?l?l?l" -dir amass4owasp
```

Note that in the configuration above we have explicitly disabled recursive DNS enumerations and alterations, as we were interested in quicker results using the mask only.

Finally, you can always check Amass' log file within the output folder to ensure your configuration is working as expected.