# Amass Intel

The Amass intel subcommand, or module if you want, can aid with collecting open source intelligence on the organisation and allow you to find further root domain names associated with the organisation. To see the available options of this subcommand, simply type it at the terminal:

```bash
$ amass intel
[...]
Usage: amass intel [options] [-whois -d DOMAIN] [-addr ADDR -asn ASN -cidr CIDR]
  -active
        Attempt certificate name grabs
  -addr value
        IPs and ranges (192.168.1.1-254) separated by commas
  -asn value
        ASNs separated by commas (can be used multiple times)
[...]
```

It is probably worth noting at this point that another great perk of Amass is that all the subcommands attempt to maintain argument consistency.

This subcommand will use a number of information gathering techniques and data sources by default, such as WHOIS and IPv4Info, in order to obtain intelligence and parent domains owned by the organisation, unless these are explicitly disabled in Amass' configuration file. An example Amass configuration file is available on the GitHub repository.

```bash
$ amass intel -d owasp.org -whois
appseceu.com
owasp.com
appsecasiapac.com
appsecnorthamerica.com
appsecus.com
[...]
owasp.org
appsecapac.com
appsecla.org
[...]
```

You can also confirm some of the results above by browsing to data sources manually. In the screenshot below, we have performed a reverse Whois search for "OWASP Foundation" and found similar domains against ViewDNS (which is also part of Amass' data sources):

[ViewDNS Reverse Whois](https://viewdns.info/reversewhois/?q=OWASP+Foundation)

When performing searches with `amass intel` you can always run it with more configuration options, such as the `-active` argument which will attempt zone transfers and actively scan to fetch SSL/TLS certificates to extract information. As with any engagement, ensure you are authorised to perform active searches against the target at the time.

It is worth noting at this point that some configuration flags will not work along with others and in this case Amass will simply ignore them.

Amass' findings will not always be accurate, this is due to several reasons, for example the data sources used by Amass may not be consistent or up to date. Amass attempts to further validate the information using DNS queries, and more validation techniques will be implemented in the future. Although Amass does a good job, users should still perform further verification checks on results that do not appear to be related to the target. This can be performed using a variety of methods such as:

- Use utilities to resolve the domains (e.g. `dig`, `nslookup`)
- Perform WHOIS lookups to confirm organisational details
- Search findings, such as parent domains, on search engines

You can also look for organisational names with Amass which could return ASN IDs assigned to the target, an example is shown below:

```bash
$ amass intel -org 'Example Ltd'
111111, MAIN_PRODUCT -- Example Ltd
222222, SECONDARY_PRODUCT - Example Ltd
[...]
```

Please note that the above data is fictitious for demonstration purposes. Retrieved ASN IDs could then be fed back into Amass. The below command attempts to retrieve parent domains on the specified ASN ID and return them along with the IP address they resolve to (127.0.0.1 in this case for demonstration purposes):

```bash
$ amass intel -active -asn 222222 -ip
some-example-ltd-domain.com 127.0.0.1
[...]
```
```